% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_distr_summary.R
\name{dtms_distr_summary}
\alias{dtms_distr_summary}
\title{Summary for distributional results}
\usage{
dtms_distr_summary(distr)
}
\arguments{
\item{distr}{An object of class `dtms_distr` created with \code{dtms_visits}, \code{dtms_first}, or \code{dtms_last}.}
}
\value{
A matrix with summary measures
}
\description{
This function provides several summary measures for results obtained
with dtms_visits, dtms_first, and dtms_last.
}
\examples{
simple <- dtms(transient=c("A","B"),
absorbing="X",
timescale=0:19)
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
fit <- dtms_fit(data=estdata)
probs <- dtms_transitions(dtms=simple,
                          model = fit)
example <- dtms_visits(dtms=simple,
                       probs=probs,
                       risk="A")
summary(example)
}
