% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tab_to_obsv_tab.R
\name{cross_tab_to_obsv_tab}
\alias{cross_tab_to_obsv_tab}
\title{Convert a contingency table to a long-format observation-level data frame}
\usage{
cross_tab_to_obsv_tab(cross_tab, strings_as_factors = TRUE)
}
\arguments{
\item{cross_tab}{A two-way or multi-way contingency table (\code{matrix} or
\code{table}) with named \code{dimnames}. Each combination of factor levels is
assumed to represent a count of occurrences.}

\item{strings_as_factors}{Should character columns in the output
be converted to factors?}
}
\value{
A \code{data.frame} in long format with one row per implied observation
and one column per dimension of the input table.
}
\description{
\code{\link[=cross_tab_to_obsv_tab]{cross_tab_to_obsv_tab()}} expands a contingency table or matrix of counts
into a long-format data frame where each row represents one observation. The
output contains one column per dimension of the input, with repeated rows
according to the frequency counts.
}
\examples{
dim_names <- list(Sex = c("Male", "Female"),
                  Response = c("Yes", "No"))
cross_tab <- matrix(c(2, 1, 3, 4), nrow = 2, dimnames = dim_names)
cross_tab_to_obsv_tab(cross_tab)

}
