% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AET02_table.R
\name{AET02_table}
\alias{AET02_table}
\title{Create AET02-style AE summary table}
\usage{
AET02_table(
  adsl,
  adae,
  patient,
  treat,
  target = "AEDECOD",
  rows_by = "AEBODSYS",
  indent = nbsp(n = 4L)
)
}
\arguments{
\item{adsl}{Subject-level dataset.}

\item{adae}{Adverse event dataset.}

\item{patient}{Unique subject identifier variable.}

\item{treat}{Treatment arm variable.}

\item{target}{Preferred term variable for grouping (default: \code{"AEDECOD"}).}

\item{rows_by}{Higher-level term for nesting (default: \code{"AEBODSYS"}).}

\item{indent}{Character or string to indent nested rows (default: 4 non-breaking spaces).}
}
\value{
A merged data.table containing AE summary.
}
\description{
Summarises adverse events in a format similar to the AET02 table from a CSR,
showing total AE counts, patients with AEs, and a breakdown by System Organ
Class (SOC) and Preferred Term (PT).
}
\examples{
# Create a AET02 table
AET02_table(
  adsl = adsl,
  adae = aesi,
  patient = "USUBJID",
  treat = "ARM",
  target = "AEDECOD",
  rows_by = "AEBODSYS",
  indent = "  "
)

}
