% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-diagnostics.R
\name{filter_drop}
\alias{filter_drop}
\alias{filter_drop.data.table}
\title{Drop Data with Diagnostic Statistics}
\usage{
filter_drop(x, ...)

\method{filter_drop}{data.table}(
  x,
  expr,
  stat = NULL,
  na_as = FALSE,
  quiet = FALSE,
  warn_threshold = NULL,
  ...
)
}
\arguments{
\item{x}{A data.table or other object.}

\item{...}{Arguments passed to methods.}

\item{expr}{A filtering expression written in terms of columns of x.
Rows where expr is TRUE are DROPPED; others are kept.}

\item{stat}{An unquoted column or expression to total, e.g., sales,
price*qty, etc. Reports the amount dropped and its share of total.}

\item{na_as}{Logical. Treat NA results of expr as this value
(default FALSE: drop rows where expr is NA).}

\item{quiet}{Logical. If TRUE, suppress printing diagnostics.}

\item{warn_threshold}{Numeric between 0 and 1. If set and the proportion of
dropped rows exceeds this threshold, a warning is issued.}
}
\value{
The filtered data.table.
}
\description{
Filters a data.table by DROPPING rows where the expression is TRUE,
while reporting statistics about dropped rows and optionally the sum of
a statistic column that was dropped.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_drop(data.table)}: Method for data.table objects

}}
\examples{
library(data.table)
DT <- data.table(
  id = 1:5,
  bad = c(FALSE, TRUE, FALSE, TRUE, FALSE),
  sales = 10:14
)

# Drop rows where bad == TRUE; report dropped statistics
DT2 <- filter_drop(DT, bad == TRUE)

# Also report dropped sales value
DT3 <- filter_drop(DT, bad == TRUE, stat = sales)

}
