% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_all.R
\name{draw_all}
\alias{draw_all}
\title{Draw Full Visualization: Decision Tree with Heatmap and Evaluation}
\usage{
draw_all(
  prepare_tree,
  heat,
  total_w = 297,
  total_h = 210,
  layout,
  x_eval_start = 15,
  y_eval_start = NULL,
  eval_text = 7,
  eval_res = NULL,
  print_eval = TRUE,
  show_col_prox = TRUE,
  show_row_prox = TRUE
)
}
\arguments{
\item{prepare_tree}{A list returned from a tree preparation function,
containing \code{plot_data} and \code{branches} for tree structure.}

\item{heat}{A \code{grob} object representing the heatmap visualization. Usually generated with \code{grid.grabExpr(draw(...))}}

\item{total_w}{Total width of the drawing in mm. Default is 297 (A4 landscape width).}

\item{total_h}{Total height of the drawing in mm. Default is 210 (A4 landscape height).}

\item{layout}{A list specifying layout parameters: \code{tree_w}, \code{tree_h}, \code{margin}, and \code{offset_h}.}

\item{x_eval_start}{X-axis starting position (in mm) for evaluation text. Default is 15.}

\item{y_eval_start}{Y-axis starting position (in mm) for evaluation text. If NULL, it will be computed automatically.}

\item{eval_text}{Font size for the evaluation text. Default is 6.}

\item{eval_res}{A list with evaluation result text from \code{eval_tree()} (including \code{data_info}, \code{train_metrics}, and \code{test_metrics}).}

\item{print_eval}{Logical, whether to show evaluation results. Default is TRUE.}

\item{show_col_prox}{Logical, whether to show column proximity.}

\item{show_row_prox}{Logical, whether to show row proximity.}
}
\value{
Draws the full visualization to the current graphics device.
Called for its side effect; returns \code{invisible(NULL)}.
}
\description{
This function creates a full-page layout consisting of a decision tree plot,
a heatmap, and optional evaluation results. It is designed for use in
reporting classification or clustering trees with additional visual indicators.
}
\examples{
\donttest{
# See dtGAP() for a full end-to-end example
# that internally calls draw_all().
}
}
