% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.lmerSLMA.R
\name{ds.lmerSLMA}
\alias{ds.lmerSLMA}
\title{Fits Linear Mixed-Effect model via Study-Level Meta-Analysis}
\usage{
ds.lmerSLMA(
  formula = NULL,
  offset = NULL,
  weights = NULL,
  combine.with.metafor = TRUE,
  dataName = NULL,
  checks = FALSE,
  datasources = NULL,
  REML = TRUE,
  control_type = NULL,
  control_value = NULL,
  optimizer = NULL,
  verbose = 0,
  notify.of.progress = FALSE,
  assign = FALSE,
  newobj = NULL
)
}
\arguments{
\item{formula}{an object of class formula describing the model to be fitted. 
For more information see \strong{Details}.}

\item{offset}{a character string specifying the name of a variable to be used as
an offset.}

\item{weights}{a character string specifying the name of a variable containing
prior regression weights for the fitting process.}

\item{combine.with.metafor}{logical. If TRUE the
estimates and standard errors for each regression coefficient are pooled across
studies using random-effects meta-analysis under maximum likelihood (ML),
restricted maximum likelihood (REML) or fixed-effects meta-analysis (FE). Default TRUE.}

\item{dataName}{a character string specifying the name of an (optional) data frame
that contains all of the variables in the LME formula. 
For more information see \strong{Details}.}

\item{checks}{logical. If TRUE \code{ds.lmerSLMA} checks the structural integrity 
of the model. Default FALSE. For more information see \strong{Details}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} objects obtained after login. 
If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}

\item{REML}{logical. If TRUE the REstricted Maximum Likelihood (REML)
is used for parameter optimization. 
If FALSE the parameters are optimized using standard ML (maximum likelihood). Default TRUE. 
For more information see \strong{Details}.}

\item{control_type}{an optional character string vector specifying the nature of a parameter
(or parameters) to be modified in the \code{convergence control options} which can be viewed or
modified via the \code{lmerControl} function of the package \code{lme4}. 
For more information see \strong{Details}.}

\item{control_value}{numeric representing the new value which you want to allocate the
control parameter corresponding to the \code{control-type}. 
For more information see \strong{Details}.}

\item{optimizer}{specifies the parameter optimizer that \code{lmer} should use.
For more information see \strong{Details}.}

\item{verbose}{an integer value. If \eqn{verbose > 0} the output is generated during the optimization of
the parameter estimates. If \eqn{verbose > 1} the output is generated during the individual penalized 
iteratively reweighted least squares (PIRLS) steps. Default \code{verbose} 
 value is 0 which means no additional output.}

\item{notify.of.progress}{specifies if console output should be produced to indicate
progress. Default FALSE.}

\item{assign}{a logical, indicates whether the function will call a second server-side function
(an assign) in order to save the regression outcomes (i.e. a lmerMod object) on each server.
Default FALSE.}

\item{newobj}{a character string specifying the name of the object to which the lmerMod object
representing the model fit on the serverside in each study is to be written. This argument is 
used only when the argument \code{assign} is set to TRUE.
If no <newobj> argument is specified, the output object defaults to "new.lmer.obj".}
}
\value{
Many of the elements of the output list returned by \code{ds.lmerSLMA} are 
equivalent to those returned by the \code{lmer()} function in native R. However,
potentially disclosive elements
such as individual-level residuals and linear predictor values are blocked. 
In this case, only non-disclosive elements are returned from each study separately.

The list of elements returned by \code{ds.lmerSLMA} is mentioned below:

\code{ds.lmerSLMA} returns a list of  elements mentioned 
below separately for each study.

\code{coefficients}: a matrix with 5 columns:
   \describe{
   \item{First}{: the names of all of the regression parameters (coefficients) in the model} 
   \item{second}{: the estimated values} 
   \item{third}{: corresponding standard errors of the estimated values} 
   \item{fourth}{: the ratio of estimate/standard error} 
   \item{fifth}{: the p-value treating that as a standardised normal deviate} 
}

\code{CorrMatrix}: the correlation matrix of parameter estimates.

\code{VarCovMatrix}: the variance-covariance matrix of parameter estimates.

\code{weights}: the vector (if any) holding regression weights.

\code{offset}: the vector (if any) holding an offset.

\code{cov.scaled}: equivalent to \code{VarCovMatrix}.

\code{Nmissing}: the number of missing observations in the given study.

\code{Nvalid}: the number of valid (non-missing) observations in the given study.

\code{Ntotal}: the total number of observations 
                       in the given study (\code{Nvalid} + \code{Nmissing}).

\code{data}: equivalent to input parameter \code{dataName} (above).

\code{call}: summary of key elements of the call to fit the model.

There are a small number of more esoteric items of the information returned
by \code{ds.lmerSLMA}. Additional information about these can be found in the help
file for the \code{lmer()} function in the \code{lme4} package.

Once the study-specific output has been returned, the function returns
several elements relating to the pooling of estimates across studies via
study-level meta-analysis. These are as follows:

\code{input.beta.matrix.for.SLMA}: a matrix containing the vector of coefficient
estimates from each study.

\code{input.se.matrix.for.SLMA}: a matrix containing the vector of standard error
estimates for coefficients from each study.

\code{SLMA.pooled.estimates}: a matrix containing pooled estimates for each
regression coefficient across all studies with pooling under SLMA via
random-effects meta-analysis under maximum likelihood (ML), restricted maximum
likelihood (REML) or via fixed-effects meta-analysis (FE).

\code{convergence.error.message}:  reports for each study whether the model converged.
If it did not some information about the reason for this is reported.
}
\description{
\code{ds.lmerSLMA} fits a Linear Mixed-Effects Model (lme) - can include both
fixed and random-effects - on data from one or multiple sources with pooling via SLMA
(Study-Level Meta-Analysis)
}
\details{
\code{ds.lmerSLMA} fits a Linear Mixed Effects Model (lme) - can include both fixed and random
effects - on data from single or multiple sources.

This function is similar to \code{lmer} function from \code{lme4} package in native R.

When there are multiple data sources,
the LME is fitted to convergence in each data source independently. The
estimates and standard errors returned to the client-side which enable cross-study pooling
using Study-Level Meta-Analysis (SLMA).  The SLMA used by default \code{metafor} package  
 but as the SLMA occurs on the client-side (a standard R environment), the user can choose 
 any approach to meta-analysis.  Additional information about fitting 
LMEs using the \code{lmer} function can be 
obtained using R help for \code{lmer} and the \code{lme4} package.

In \code{formula} most shortcut notation allowed by  \code{lmer()} function is
also allowed by \code{ds.lmerSLMA}. Many LMEs can be fitted very simply using a formula like:
\eqn{y ~ a + b + (1 | c)}
which simply means fit an LME with \code{y} as the outcome variable with \code{a} and \code{b}
as fixed effects, and \code{c} as a random effect or grouping factor.

It is also possible to fit models with random slopes by specifying a model such as 
\eqn{y ~ a + b + (1 + b | c)}
where the effect of \code{b} can vary randomly between groups defined by \code{c}.
Implicit nesting can be specified with formulae such as \eqn{y ~ a + b + (1 | c / d)}
or \eqn{y ~ a + b + (1 | c) + (1 | c : d)}.

The \code{dataName} argument avoids you having to specify the name of the
data frame in front of each covariate in the formula. 
For example, if the data frame is called \code{DataFrame} you avoid having to write: 
\eqn{DataFrame\$y ~ DataFrame\$a + DataFrame\$b + (1 | DataFrame\$c)}.

The \code{checks} argument verifies that the variables in the model are all defined (exist) 
on the server-site at every study
and that they have the correct characteristics required to fit the model. 
It is suggested to make \code{checks} argument TRUE if an unexplained
problem in the model fit is encountered because the running process takes several minutes.

\code{REML} can help to mitigate
bias associated with the fixed-effects. See help on the \code{lmer()} function for more details.

In \code{control_type} at present only one such parameter can be modified,
namely the tolerance of the convergence criterion to the gradient of the log-likelihood 
at the maximum likelihood achieved. We have enabled this because our practical experience
suggests that in situations where the model looks to have converged with sensible parameter
values but formal convergence is not being declared if we allow the model to be more
tolerant to a non-zero gradient the same parameter values are obtained but formal
convergence is declared. The default value for the \code{check.conv.grad} is \code{0.002}. 

\code{control_value} At present (see \code{control_type})
the only parameter this can be is the convergence tolerance \code{check.conv.grad}. In
general, models will be identified as having converged more readily if the value set
for \code{check.conv.grad} is increased from its default (\code{0.002}).  Please note
that the risk of doing this is that the model is also more likely to be declared
as having converged at a local maximum that is not the global maximum likelihood.
This will not generally be a problem if the likelihood surface is well behaved but if
you have a problem with convergence you might usefully compare all the parameter
estimates and standard errors obtained using the default tolerance (\code{0.002}) even though
that has not formally converged with those obtained after convergence using the higher
tolerance. 

The \code{optimizer} argument is built in but it won't do anything because there is only one
standard optimizer available for lmer - this is the \code{nloptwrap} optimizer. If users
wish to apply a different optimizer - potentially one they have developed themselves -
the development team can activate this argument so alternatives can be specified.

Server function called: \code{lmerSLMADS2}
}
\examples{
\dontrun{

 ## Version 6, for version 5 see Wiki
  # Connecting to the Opal servers
  
  require('DSI')
  require('DSOpal')
  require('dsBaseClient')
  
  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CLUSTER.CLUSTER_SLO1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CLUSTER.CLUSTER_SLO2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CLUSTER.CLUSTER_SLO3", driver = "OpalDriver")
  logindata <- builder$build()
  
   #Log onto the remote Opal training servers
   connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D")
               
  # Select all rows without missing values
  ds.completeCases(x1 = "D", newobj = "D.comp", datasources = connections)
 
  # Fit the lmer
  
  ds.lmerSLMA(formula = "BMI ~ incid_rate + diabetes + (1 | Male)",
               dataName = "D.comp",
               datasources = connections)
  
  # Clear the Datashield R sessions and logout
  datashield.logout(connections) 
  }
}
\author{
DataSHIELD Development Team
}
