% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_binding.R
\name{data_binding}
\alias{data_binding}
\title{Merge all the dataframes coming out from the QuPath}
\usage{
data_binding(
  path_to_the_projects_folder,
  files_extension_to_look_for = "csv",
  recursive_search = FALSE,
  forcePath = NULL
)
}
\arguments{
\item{path_to_the_projects_folder}{String/Path The path where the files coming out of QuPath are located}

\item{files_extension_to_look_for}{String The extension of the file outputted from QuPath, (default is "csv")}

\item{recursive_search}{Boolean, it defined the behavior of the file search, if recursive or not, (default is FALSE)}

\item{forcePath}{String defining an alternative path to the confic file}
}
\value{
A concatenated dataframe from all the files within the indicated path
}
\description{
This function identifies string patterns in the dataset, fills the dataframe
with that information, and combines all data into a single file
}
\examples{
\dontrun{
bind_data <- data_binding(path_to_the_projects_folder = system.file("extdata/to_merge/",
                         package = "drugsens"))
}
}
