% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.drugdevelopResult.R
\name{print.drugdevelopResult}
\alias{print.drugdevelopResult}
\title{Printing a drugdevelopResult Object}
\usage{
\method{print}{drugdevelopResult}(x, sequence = FALSE, ...)
}
\arguments{
\item{x}{Data frame of class \code{drugdevelopResult}.}

\item{sequence}{logical, print optimization sequence (default = \code{FALSE})?}

\item{...}{Further arguments.}
}
\description{
Displays details about the optimal results from a \code{drugdevelopResult} object.
}
\examples{
\donttest{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
res <- optimal_normal(w=0.3,                       
  Delta1 = 0.375, Delta2 = 0.625, in1=300, in2=600,  
  a = 0.25, b = 0.75,
  n2min = 20, n2max = 100, stepn2 = 4,               
  kappamin = 0.02, kappamax = 0.2, stepkappa = 0.02, 
  alpha = 0.025, beta = 0.1,                       
  c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,   
  K = Inf, N = Inf, S = -Inf,                        
  steps1 = 0,                                      
  stepm1 = 0.5,                                      
  stepl1 = 0.8,                                      
  b1 = 3000, b2 = 8000, b3 = 10000,                  
  gamma = 0,                                         
  fixed = FALSE,                                    
  skipII = FALSE,                                    
  num_cl = 1)
# Print results
print(res)                                  
}
}
\keyword{internal}
