% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_tte.R
\name{Ess_multiple_tte}
\alias{Ess_multiple_tte}
\title{Expected sample size for phase III for multiple endpoints with normally distributed outcomes}
\usage{
Ess_multiple_tte(HRgo, n2, alpha, beta, hr1, hr2, id1, id2, fixed, rho)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule;}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{one- sided significance level}

\item{beta}{\code{1-beta} power for calculation of the number of events for phase III by Schoenfeld (1981) formula}

\item{hr1}{assumed true treatment effect on HR scale for endpoint OS}

\item{hr2}{assumed true treatment effect on HR scale for endpoint PFS}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random}

\item{rho}{correlation between the two endpoints}
}
\value{
the output of the function \code{Ess_multiple_tte()} is the expected number of participants in phase III
}
\description{
Given phase II results are promising enough to get the "go"-decision to go to phase III this function now calculates the expected sample size for phase III.
The results of this function are necessary for calculating the utility of the program, which is then in a further step maximized by the \code{optimal_multiple_tte()} function
}
\keyword{internal}
