% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runGMM.R
\name{runGMM}
\alias{runGMM}
\title{Function to fit Gaussian Mixture Model (GMM) to 1D data}
\usage{
runGMM(X, Y = NULL, opts = NULL)
}
\arguments{
\item{X}{Vector of 1D data for GMM decomposition.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{opts}{Parameters of run saved in \code{\link{GMM_1D_opts}} variable.}
}
\value{
Function returns a \code{list} which contains: \describe{
 \item{model}{A \code{list} of model component parameters - mean values (mu), standard deviations (sigma)
 and weights (alpha) for each component. Output of \code{\link{gaussian_mixture_vector}}.}
 \item{KS}{Estimaged number of model components.}
 \item{IC}{The value of the selected information criterion which was used to calculate the number of components.}
 \item{logLik}{Log-likelihood statistic for the estimated number of components.}
 \item{threshold}{Vector of thresholds between each component.}
 \item{cluster}{Assignment of original \code{X} values to individual components (clusters) by thresholds.}
 \item{fig}{ggplot object (output of the \code{\link{plot_gmm_1D}} function). It contains GMM decomposition together with a histogram of the data.}
 \item{QQplot}{ggplot object (output of the \code{\link{plot_QQplot}} function).
 It presents diagnostic Quantile-Quantile plot for a single normal distribution and fitted GMM.}
}
}
\description{
Function fits GMM with initial conditions found using dynamic programming-based approach by using expectation-maximization (EM) algorithm.
The function works on original and binned (e.g. obtained by creating histogram on 1D data) data. Additionally, threshold values that allows to assign data to individual Gaussian components are provided.
Function allows to estimate the number of GMM components using five different information criteria and merging of similar components.
}
\examples{
\donttest{
data(example)

custom.settings <- GMM_1D_opts
custom.settings$sigmas.dev <- 1.5
custom.settings$max_iter <- 1000
custom.settings$KS <- 10

mix_test <- runGMM(example$Dist, opts = custom.settings)
mix_test$QQplot

#example for binned data
data(binned)

custom.settings <- GMM_1D_opts
custom.settings$quick_stop <- TRUE
custom.settings$KS <- 40
custom.settings$col.pal <- "Dark2"
custom.settings$plot <- FALSE

binned_test <- runGMM(X = binned$V1, Y = binned$V2, opts = custom.settings)
binned_test$fig
}

}
\seealso{
\code{\link{gaussian_mixture_vector}}, \code{\link{EM_iter}}
}
