% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_legend_with_stats.R
\name{make_legend_with_stats}
\alias{make_legend_with_stats}
\title{Make legends with stats}
\usage{
make_legend_with_stats(
  data,
  namecol,
  start_column_idx = 2,
  first_justified_left = FALSE
)
}
\arguments{
\item{data}{dataframe with columns to be merged into 1}

\item{namecol}{name to be given to new column}

\item{start_column_idx}{numeric index of first column to process}

\item{first_justified_left}{boolean when \code{TRUE} justifies first column to the left, defaults to \code{FALSE}}
}
\value{
data.frame with combined source columns
}
\description{
This function merges all columns in a dataframe
to be used as legends
}
\examples{
fabaceae_mode_counts <- get_modes_counts(fabaceae_clade_n_df, "clade", "parsed_n")
fabaceae_clade_n_df_count <- make_legend_with_stats(fabaceae_mode_counts, "label_count", 1, TRUE)
fabaceae_Cx_mode_counts_per_clade_df <- get_peaks_counts_continuous(
  fabaceae_clade_1Cx_df,
  "clade", "Cx", 2, 0.25, 1, 2
)
namecol <- "labelcountcustom"
fabaceae_clade_1Cx_modes_count_df <- make_legend_with_stats(
  fabaceae_Cx_mode_counts_per_clade_df,
  namecol, 1, TRUE
)
}
\keyword{legend}
