% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots_and_violin.R
\name{dots_and_violin}
\alias{dots_and_violin}
\title{Makes a composite dot-plot and violin-plot}
\usage{
dots_and_violin(
  dataframe,
  colgroup,
  collabel,
  maxcountcol,
  widthdots,
  maxx,
  labelx,
  desiredorder,
  binwidth,
  adjust,
  binexp,
  fill_group = "fill_group",
  dots = TRUE,
  violin = TRUE
)
}
\arguments{
\item{dataframe}{dataframe}

\item{colgroup}{chr column to group by}

\item{collabel}{label to be used in the plot}

\item{maxcountcol}{numeric variable}

\item{widthdots}{dotsize parameter for geom_dotplot}

\item{maxx}{x axis maximum value}

\item{labelx}{label for x axis}

\item{desiredorder}{order for the colgroup categories}

\item{binwidth}{see, plot_dotviolin}

\item{adjust}{adjust param, see geom_violin}

\item{binexp}{digit to modify size of bins with base 10}

\item{fill_group}{2nd categorical data (use only 2 categories)}

\item{dots}{boolean include dot plot}

\item{violin}{boolean include violin plot}
}
\value{
A grid of ggplots that mimics a single plot
}
\description{
This function makes a dot-plot and violin-plot
}
\examples{
fabaceae_mode_counts <- get_modes_counts(fabaceae_clade_n_df, "clade", "parsed_n")
fabaceae_clade_n_df_count <- make_legend_with_stats(fabaceae_mode_counts, "label_count", 1, TRUE)
fabaceae_clade_n_df$label_count <- fabaceae_clade_n_df_count$label_count[match(
  fabaceae_clade_n_df$clade,
  fabaceae_clade_n_df_count$clade
)]
desiredorder1 <- unique(fabaceae_clade_n_df$clade)

dots_and_violin(
  fabaceae_clade_n_df, "clade", "label_count", "parsed_n", 2,
  30, "Chromosome haploid number", desiredorder1, 1, .85, 4,
  "ownwork",
  violin = FALSE
)
\donttest{
dots_and_violin(
  fabaceae_clade_n_df, "clade", "label_count", "parsed_n", 2,
  30, "Chromosome haploid number", desiredorder1, 1, .85, 4,
  dots = FALSE
)
dots_and_violin(
  fabaceae_clade_n_df, "clade", "label_count", "parsed_n", 2,
  30, "Chromosome haploid number", desiredorder1, 1, .85, 4
)
}
fabaceae_Cx_mode_counts_per_clade_df <- get_peaks_counts_continuous(
  fabaceae_clade_1Cx_df,
  "clade", "Cx", 2, 0.25, 1, 2
)

namecol <- "labelcountcustom"
fabaceae_clade_Cx_peaks_count_df <- make_legend_with_stats(
  fabaceae_Cx_mode_counts_per_clade_df,
  namecol, 1, TRUE
)
fabaceae_clade_1Cx_df$labelcountcustom <-
  fabaceae_clade_Cx_peaks_count_df$labelcountcustom[match(
    fabaceae_clade_1Cx_df$clade,
    fabaceae_clade_Cx_peaks_count_df$clade
  )]
desiredorder <- unique(fabaceae_clade_1Cx_df$clade)

dots_and_violin(
  fabaceae_clade_1Cx_df, "clade", "labelcountcustom", "Cx", 3,
  3, "Genome Size", desiredorder, 0.03, 0.25, 2,
  "ownwork"
)
\donttest{
dots_and_violin(
  fabaceae_clade_1Cx_df, "clade", "labelcountcustom", "Cx", 3,
  3, "Genome Size", desiredorder, 0.03, 0.25, 2,
  dots = FALSE
)
dots_and_violin(
  fabaceae_clade_1Cx_df, "clade", "labelcountcustom", "Cx", 3,
  3, "Genome Size", desiredorder, 0.03, 0.25, 2,
  "ownwork",
  violin = FALSE
)
}
}
\keyword{dot-plot}
\keyword{violin-plot}
