
expect_captured_length <- function(x, length) {
  expect_equal(length(capture.output(x)), length)
}

test_that("R6 creation works", {
  my_dock <- Dockerfile$new()
  expect_s3_class(my_dock, "R6")
  expect_s3_class(my_dock, "Dockerfile")
  my_dock$RUN("mkdir /usr/scripts")
  expect_captured_length(my_dock, 2)
  my_dock$ADD("from", "/usr/scripts")
  expect_captured_length(my_dock, 3)
  my_dock$COPY("from", "/usr/scripts")
  expect_captured_length(my_dock, 4)
  my_dock$WORKDIR("/usr/scripts")
  expect_captured_length(my_dock, 5)
  my_dock$EXPOSE(888)
  expect_captured_length(my_dock, 6)
  my_dock$VOLUME(" /usr/scripts")
  expect_captured_length(my_dock, 7)
  my_dock$CMD(" /usr/scripts")
  expect_captured_length(my_dock, 8)
  my_dock$LABEL("plop", "/usr/scripts")
  expect_captured_length(my_dock, 9)
  my_dock$ENV("plop", " /usr/scripts")
  expect_captured_length(my_dock, 10)
  my_dock$ENTRYPOINT("plop  /usr/scripts")
  expect_captured_length(my_dock, 11)
  my_dock$USER("plop  /usr/scripts")
  expect_captured_length(my_dock, 12)
  my_dock$ARG("plop /usr/scripts")
  expect_captured_length(my_dock, 13)
  my_dock$ONBUILD("plop /usr/scripts")
  expect_captured_length(my_dock, 14)
  my_dock$STOPSIGNAL("plop /usr/scripts")
  expect_captured_length(my_dock, 15)
  my_dock$HEALTHCHECK("plop /usr/scripts")
  expect_captured_length(my_dock, 16)
  my_dock$MAINTAINER("colin", "contact@colinfay.me")
  expect_captured_length(my_dock, 17)
  my_dock$SHELL("plop /usr/scripts")
  expect_captured_length(my_dock, 18)
  my_dock$remove_cmd(1)
  expect_captured_length(my_dock, 17)
  my_dock$switch_cmd(5, 6)
  expect_captured_length(my_dock, 17)
  my_dock$COMMENT("Just testing Dockerfile comments.")
  expect_captured_length(my_dock, 18)

  my_dock <- Dockerfile$new(FROM = "plop")
  expect_match(my_dock$Dockerfile, "plop")
  my_dock <- Dockerfile$new(FROM = "plop", AS = "pouet")
  expect_match(my_dock$Dockerfile, "plop")
  expect_match(my_dock$Dockerfile, "pouet")
})

test_that("warning works", {
  my_dock <- Dockerfile$new()
  # expect_warning(my_dock$COPY("nfi", "norifi", force = FALSE))
  expect_warning(my_dock$EXPOSE("9000"))
})
