% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{occSilur}
\alias{occSilur}
\title{Paleobiology Database occurrences of Silurian fossil brachiopods}
\format{
A data frame with 13502 rows and 11 variables:
\describe{
\item{order, family, genus}{Latin order, family, and genus name,
as synonymised against Sepkoski database}
\item{paleolng, paleolat}{Coordinates of an occurrence, rotated to
its palaeogeographic location with the tectonic plate model of
\href{https://www.earthbyte.org/}{GPlates}}
\item{collection_no, reference_no}{Unique identifiers for the collection
and published reference containing the occurrence}
\item{environment}{One of 23 marine environment categories}
\item{max_ma, min_ma}{Bounds of the age estimate for an occurrence,
according to the ICS 2013 geologic time scale.}
\item{accepted_name}{Original identification, including subgenus and
species epithet if applicable, according to the latest PBDB
accepted taxonomy at time of download}
}
}
\source{
\url{https://paleobiodb.org/}
}
\usage{
occSilur
}
\description{
A dataset containing the (palaeo)coordinates and genus identifications of
13,500 marine brachiopods from the Silurian (443.1-419 Ma). Records with
uncertain or unaccepted taxonomic names, non-marine palaeo-environments,
or missing coordinates are excluded from the original download (29 July 2022).
Taxonomic synonymisation and removal of stratigraphic outliers
follows the \code{fossilbrush} vignette example of cross-correlation with the
Sepkoski range-through database \verb{[fossilbrush::sepkoski()]}.
}
\keyword{datasets}
