# calc_epsp <-
#   function(transformed_residuals, res_order, grouping_matrix){
#     stopifnot(is.numeric(transformed_residuals), is.vector(transformed_residuals),
#               is.numeric(res_order), is.vector(res_order),
#               identical(length(transformed_residuals), length(res_order)),
#               is.null(grouping_matrix) ||
#                 (is.numeric(grouping_matrix) && is.vector(grouping_matrix) &&
#                    identical(length(grouping_matrix), length(transformed_residuals))))
#     if(is.null(grouping_matrix)){
#       output <- cumsum(transformed_residuals[res_order])/sqrt(length(transformed_residuals))
#     } else {
#       output <- cumsum(as.vector(rowsum(x = transformed_residuals,
#                                         group = grouping_matrix, reorder = TRUE))/sqrt(length(unique(grouping_matrix))))
#     }
#     return(output)
#   }

calc_epsp <-
  function(transformed_residuals, res_order, grouping_matrix){
    stopifnot(is.numeric(transformed_residuals), is.vector(transformed_residuals),
              is.numeric(res_order), is.vector(res_order),
              identical(length(transformed_residuals), length(res_order)),
              is.null(grouping_matrix) || is.matrix(grouping_matrix))
    if(is.null(grouping_matrix)){
      output <- cumsum(transformed_residuals[res_order])/sqrt(length(transformed_residuals))
    } else {
      output <- cumsum(as.vector(transformed_residuals %*% grouping_matrix))/sqrt(ncol(grouping_matrix))
    }
    return(output)
  }
