% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distance_chi_cpp}
\alias{distance_chi_cpp}
\title{(C++) Normalized Chi Distance Between Two Vectors}
\usage{
distance_chi_cpp(x, y)
}
\arguments{
\item{x}{(required, numeric vector).}

\item{y}{(required, numeric vector) of same length as \code{x}.}
}
\value{
numeric
}
\description{
Computed as:
\code{xy <- x + y}
\code{y. <- y / sum(y)}
\code{x. <- x / sum(x)}
\code{sqrt(sum(((x. - y.)^2) / (xy / sum(xy))))}.
Cannot handle NA values. When \code{x} and \code{y} have zeros in the same
position, \code{NaNs} are produced. Please replace these zeros with
pseudo-zeros (i.e. 0.0001) if you wish to use this distance metric.
}
\examples{
distance_chi_cpp(x = runif(100), y = runif(100))
}
\seealso{
Other Rcpp_distance_methods: 
\code{\link{distance_bray_curtis_cpp}()},
\code{\link{distance_canberra_cpp}()},
\code{\link{distance_chebyshev_cpp}()},
\code{\link{distance_cosine_cpp}()},
\code{\link{distance_euclidean_cpp}()},
\code{\link{distance_hamming_cpp}()},
\code{\link{distance_hellinger_cpp}()},
\code{\link{distance_jaccard_cpp}()},
\code{\link{distance_manhattan_cpp}()},
\code{\link{distance_russelrao_cpp}()},
\code{\link{distance_sorensen_cpp}()}
}
\concept{Rcpp_distance_methods}
