% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{sort.dispRity}
\alias{sort.dispRity}
\title{Sorting or ordering a \code{dispRity} object.}
\usage{
\method{sort}{dispRity}(x, decreasing = FALSE, sort, ...)
}
\arguments{
\item{x}{A \code{dispRity} object.}

\item{decreasing}{\code{logical}. Should the sort be in ascending or descending order? Is ignored if \code{sort} is used.}

\item{sort}{An optional \code{vector} of \code{numeric} values corresponding to the order in which to return the subsets.}

\item{...}{optional arguments to be passed to \code{sort}.}
}
\description{
Sort (or order) the subsets of a \code{dispRity} object.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Sorting the data
summary(disparity)
summary(sort(disparity, decreasing = TRUE))
summary(sort(disparity, sort = c(7,1,3,4,5,2,6)))

}
\seealso{
\code{\link{dispRity}}, \code{\link{test.dispRity}}, \code{\link{plot.dispRity}}, \code{\link{get.subsets}}, \code{\link{get.disparity}}.
}
\author{
Thomas Guillerme
}
