% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_title.R
\name{suggest_title}
\alias{suggest_title}
\title{Suggest title words}
\usage{
suggest_title(abstract, keywords, fulltext, suggest = FALSE)
}
\arguments{
\item{abstract}{An article abstract}

\item{keywords}{An article keywords, supplied as a vector}

\item{fulltext}{An article full text}

\item{suggest}{A logical argument of TRUE or FALSE. If TRUE, the output data frame returned is
sub-setting to only include potential keywords (i.e. those not already in the abstract or keywords)}
}
\value{
A data frame consisting of potential candidate title words and their suitability. If suggest
= FALSE, only good candidates are returned.
}
\description{
Suggests possible title words by extracting uni-, 'bi-, and tri-grams from a long text (e.g.
article full text), having removed punctuation and stop words. Returns the remaining words as a
vector of strings and assesses whether they are already present in the title or abstract
}
\examples{
abstract <- "Systematic mapping was developed in social sciences in response to a lack of empirical 
  data when answering questions using systematic review methods, and a need for a method to describe 
  the literature across a broad subject of interest. Systematic mapping does not attempt to answer 
  a specific question as do systematic reviews, but instead collates, describes and catalogues 
  available evidence (e.g. primary, secondary, theoretical, economic) relating to a topic or 
  question of interest. The included studies can be used to identify evidence for policy-relevant 
  questions, knowledge gaps (to help direct future primary research) and knowledge clusters (sub-
  sets of evidence that may be suitable for secondary research, for example systematic review). 
  Evidence synthesis in environmental sciences faces similar challenges to those found in social 
  sciences. Here we describe the translation of systematic mapping methodology from social sciences 
  for use in environmental sciences. We provide the first process-based methodology for systematic 
  maps, describing the stages involved: establishing the review team and engaging stakeholders; 
  setting the scope and question; setting inclusion criteria for studies; scoping stage; protocol 
  development and publication; searching for evidence; screening evidence; coding; production of a 
  systematic map database; critical appraisal (optional); describing and visualising the findings; 
  report production and supporting information. We discuss the similarities and differences in 
  methodology between systematic review and systematic mapping and provide guidance for those 
  choosing which type of synthesis is most suitable for their requirements. Furthermore, we discuss 
  the merits and uses of systematic mapping and make recommendations for improving this evolving 
  methodology in environmental sciences."
keywords <- c("Systematic mapping", 
  "Evidence-based environmental management", 
  "Systematic evidence synthesis", 
  "Evidence review", 
  "Knowledge gaps", 
  "Knowledge clusters")
filepath <- system.file("extdata", "fulltext.rds", package="discoverableresearch")
fulltext <- readRDS(filepath)
fulltext <- gsub("\n", " ", fulltext)
fulltext <- gsub("\\\\s+"," ",fulltext)
poss_titlewords <- suggest_title(abstract, keywords, fulltext)
poss_titlewords;
}
