% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet_process_hierarchical_beta.R
\name{DirichletProcessHierarchicalBeta}
\alias{DirichletProcessHierarchicalBeta}
\title{Create a Hierarchical Dirichlet Mixture of Beta Distributions}
\usage{
DirichletProcessHierarchicalBeta(
  dataList,
  maxY,
  priorParameters = c(2, 8),
  hyperPriorParameters = c(1, 0.125),
  gammaPriors = c(2, 4),
  alphaPriors = c(2, 4),
  mhStepSize = c(0.1, 0.1),
  numSticks = 50,
  mhDraws = 250
)
}
\arguments{
\item{dataList}{List of data for each separate Dirichlet mixture object}

\item{maxY}{Maximum value for the Beta distribution.}

\item{priorParameters}{Prior Parameters for the top level base distribution.}

\item{hyperPriorParameters}{Hyper prior parameters for the top level base distribution.}

\item{gammaPriors}{Prior parameters for the top level concentration parameter.}

\item{alphaPriors}{Prior parameters for the individual parameters.}

\item{mhStepSize}{Metropolis Hastings jump size.}

\item{numSticks}{Truncation level for the Stick Breaking formulation.}

\item{mhDraws}{Number of Metropolis-Hastings samples to perform for each cluster update.}
}
\value{
dpobjlist A Hierarchical Dirichlet Process object that can be fitted, plotted etc.
}
\description{
Create a Hierarchical Dirichlet Mixture of Beta Distributions
}
