% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{rif}
\alias{rif}
\title{Recentered influence function (RIF)}
\usage{
rif(x, weights = NULL, method = "quantile", quantile = 0.5,
  kernel = "gaussian")
}
\arguments{
\item{x}{a numeric vector for which the recentered influence function is computed.}

\item{weights}{an optional vector of weights of x to be used in the computation of the
recentered influence function. Should be NULL or a numeric vector.}

\item{method}{the distribution statistic for which the recentered influence function is
estimated. Options are "quantile", "gini" and "variance". Default is "quantile".}

\item{quantile}{quantile to be used when method "quantile" is selected. Must be a numeric
between 0 and 1. Default is 0.5 (median). Only a single quantile can be selected.}

\item{kernel}{a character giving the smoothing kernel to be used in method "quantile". Options
are "gaussian", "rectangular", "triangular", "epanechnikov", "biweight", "cosine"
or "optcosine". Default is "gaussian".}
}
\value{
A numeric vector of the recentered influence function of the selected distributional
statistic.
}
\description{
Returns the (optional weighted) recentered influence function of a distributional
statistic.
}
\details{
The RIF can be used as input for a RIF regression approach. RIF regressions are mostly
used to estimate the marginal effect of covariates on distributional statistics of income or
wealth.

The RIF is calculated by adding the distributional statistic (quantile, gini or variance) to
the influence function. RIF is a numeric vector where each element corresponds to a particular
individual’s influence on the distributional statistic.
}
\examples{
data(mex_inc_2008)

#Recentered influence funtion of 20th quantile
rif_q20 <- rif(x=mex_inc_2008$income, weights=mex_inc_2008$factor, method="quantile",
quantile=0.2)

#Recentered influence funtion of the gini coefficient
rif_gini <- rif(x=mex_inc_2008$income, weights=mex_inc_2008$factor, method="gini")

}
\references{
Firpo, S., N. Fortin and T. Lemieux (2009) Unconditional quantile regressions. \emph{Econometrica},
77(3), p. 953-973.

Heckley G, U.-G. Gerdtham U-G and G. Kjellsson (2016) A general method for decomposing the
causes of socioeconomic inequality in health. \emph{Journal of Health Economics},48, p. 89–106.

Pereira, J. and A. Galego (2016) The drivers of wage inequality across Europe, a recentered
influence function regression approach, \emph{10th Annual Meeting of the Portuguese Economic
Journal}, University of Evora.
}
\seealso{
\code{\link{rifr}}
}
