% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annot.file.R
\docType{data}
\name{annot.file}
\alias{annot.file}
\title{Cytoband annotation data frame}
\format{
This four-column data frame contains cytoband annotation data that is used by the \code{\link{makeCytoband}}
function.  Each row corresponds to a distinct cytoband, and column 1 contains the chromosome number, column 2
contains the start position (in base pairs), column 3 contains the end position (in base pairs), and column 4
contains the cytoband name (e.g. p21.3).  Additional columns may be present, but they are not used.
}
\source{
\url{http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/}
}
\usage{
annot.file
}
\description{
Cytoband annotation information from the hg19 genome build
}
\details{
The file cytoBand.txt.gz for the hg19 build can be downloaded from the UCSC Genome Browser at
\url{http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/}.  The format of cytoBand.txt differs from that
of annot.file, but it can be used by the function \code{\link{makeCytoband}} if \code{reformat.cytoband = TRUE}.
}
\keyword{datasets}
