% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plot.diffee}
\alias{plot.diffee}
\title{Plot diffee result specified by user input}
\usage{
\method{plot}{diffee}(x, graphlabel = NULL, type = "task", index = NULL,
  graphlayout = NULL, ...)
}
\arguments{
\item{x}{output generated from diffee function (diffee class)}

\item{graphlabel}{vertex names for the graph, there are three options:
(1) NA (no label)
(2) NULL (default numeric label according to the feature order)
(3) a vector of labels (a vector of labels cooresponding to x)
deault value is NULL}

\item{type}{type of graph, there are four options:
(1) "task" (graph for each task (including shared part) specified further by subID (task number))
(2) "neighbour" (zoom into nodes in the graph specified further by index (node id))}

\item{index}{determines which node(s) to zoom into when parameter type is "neighbour"
could either be an integer or vector of integers representing node ids
(zoom into one node or multiple nodes)}

\item{graphlayout}{layout for the graph (two column matrix specifying x,y coordinates of each node in graph)
if not provided, igraph will use the default layout_nicely() function to present the graph}

\item{...}{extra parameters passed to plot.igraph}
}
\value{
a plot of graph / subgraph from diffee result specified by user input
}
\description{
This function can plot and return multiple sparse graphs distinguished by edge colors
from the result generated by diffee
}
\details{
when only the diffee is provided, the function will plot all graphs with default numeric labels
User can specify multiple subID and multiple index to zoom in multiple nodes on multiple graphs
Each graph will include a descriptive title.
}
\examples{
\dontrun{
data(exampleData)
result = diffee(exampleData[[1]], exampleData[[2]], 0.45)
plot.diffee(result)
}
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Beilun Wang (maintainer)
}
