# tests/testthat/test-GPdiffMesh.R
test_that("GPdiffMesh function works with simple example", {
  # Simple test data
  set.seed(123)
  n <- 10
  X <- matrix(runif(2*n), ncol = 2)
  Y <- rowSums(X) + rnorm(n, sd = 0.1)
  meshT <- runif(n, 0.01, 0.1)
  x_pred <- matrix(runif(4), ncol = 2)

  # Test that function runs without error
  result <- try(
    GPdiffMesh(x = x_pred, X = X, meshT = meshT, Y = Y, l = 2),
    silent = TRUE
  )

  expect_false(inherits(result, "try-error"))
  expect_named(result, c("outy", "sigy", "estipar"))
  expect_equal(dim(result$outy), c(2, 1))
  expect_equal(dim(result$sigy), c(2, 1))
})
