% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_plates.R
\name{optimize_multi_plate_design}
\alias{optimize_multi_plate_design}
\title{Convenience wrapper to optimize a typical multi-plate design}
\usage{
optimize_multi_plate_design(
  batch_container,
  across_plates_variables = NULL,
  within_plate_variables = NULL,
  plate = "plate",
  row = "row",
  column = "column",
  n_shuffle = 1,
  max_iter = 1000,
  quiet = FALSE
)
}
\arguments{
\item{batch_container}{Batch container (bc) with all columns that denote plate related information}

\item{across_plates_variables}{Vector with bc column name(s) that denote(s) groups/conditions to be balanced across plates,
sorted by relative importance of the factors}

\item{within_plate_variables}{Vector with bc column name(s) that denote(s) groups/conditions to be spaced out within each plate,
sorted by relative importance of the factors}

\item{plate}{Name of the bc column that holds the plate identifier}

\item{row}{Name of the bc column that holds the plate row number (integer values starting at 1)}

\item{column}{Name of the bc column that holds the plate column number (integer values starting at 1)}

\item{n_shuffle}{Vector of length 1 or larger, defining how many random sample
swaps should be performed in each iteration. See \code{\link[=optimize_design]{optimize_design()}}.}

\item{max_iter}{Stop any of the optimization runs after this maximum number of iterations. See \code{\link[=optimize_design]{optimize_design()}}.}

\item{quiet}{If TRUE, suppress informative messages.}
}
\value{
A list with named traces, one for each optimization step
}
\description{
The batch container will in the end contain the updated experimental layout
}
