% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_aggregation.R
\name{worst_score}
\alias{worst_score}
\title{Aggregation of scores: take the maximum (i.e. worst score only)}
\usage{
worst_score(scores, na.rm = FALSE, ...)
}
\arguments{
\item{scores}{A score or multiple component score vector}

\item{na.rm}{Boolean. Should NA values be ignored when obtaining the maximum? FALSE by default as ignoring NA values may hide some issues with the provided scoring functions and also the aggregated value cannot be seen as the proper infinity norm anymore.}

\item{...}{Parameters to be ignored by this aggregation function}
}
\value{
The aggregated score, i.e. the value of the largest element in a multiple-component score vector.
}
\description{
This function enables comparison of the results of two scoring functions by just basing
the decision on the largest element. This corresponds to the infinity-norm in ML terms.
}
\examples{
worst_score(c(3, 2, 1))
}
