% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.outlier.R
\name{spatial.outlier}
\alias{spatial.outlier}
\title{Multivariate Spatial Outlier}
\usage{
spatial.outlier(data, x = data, threshold = 0.05)
}
\arguments{
\item{data}{A matrix or a data.frame of p-variate observations which works as the data cloud.}

\item{x}{A matrix or a data.framep-variate to test whether is an outlier with respect to the \code{data}. Defaults to \code{data}, to find outliers (if exists) within the data.}

\item{threshold}{A decimal threshold between \code{0} and \code{1} on the \code{\link{spatial.depth}}. \code{Spatial depth} values less than which will be considered as \code{outlier}. Defaults to \code{0.05}. Usually taken as \code{0.1} or \code{0.05} or \code{0.01}.}
}
\value{
\code{FALSE}  :: If there doesnot exist any outlier

A list with objects (If outliers exist)

\code{index}  :: Returns the indices of the outliers

\code{observation}  :: Returns the p-variate outliers
}
\description{
\code{spatial.outlier} is used to find the multivariate spatial outlier within a p-variate data cloud or to identify if any p-variate observation is an outlier with respect to a p-variate data cloud.
}
\examples{
u<-matrix(rnorm(60,0,1),ncol=3)
u0<-matrix(runif(9,3,4),ncol=3)
spatial.outlier(u,rbind(u,u0))
}
\author{
Somedip Karmakar <somedip@yahoo.co.in>

Omker Mahalanobish <omker.scorpio@gmail.com>
}

