% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaccd_plot.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Visualize gene co-expression.}
\usage{
plotHeatmap(geneNames, emat, groupVec = NULL)
}
\arguments{
\item{geneNames}{Vector indicating the subset of genes in the rownames of
\code{emat} for which to calculate the correlations in expression.}

\item{emat}{Matrix of expression values, where each row corresponds to a
gene and each column corresponds to a sample. The elements of \code{geneNames}
should be present in the rownames of \code{emat}.}

\item{groupVec}{Optional vector indicating the group to which group each
sample belongs. If not provided, the function assumes all samples belong
to the same group.}
}
\value{
A \code{ggplot} object, which can be saved using \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.
Heatmap colors will be directly comparable to any heatmaps created by this
function or by \code{\link[=plotRefHeatmap]{plotRefHeatmap()}}.
}
\description{
Make heatmaps of the co-expression (Spearman correlation) between pairs of
selected genes in a dataset.
}
\examples{
refCor = getRefCor()
pRef = plotRefHeatmap(refCor)
pTest = plotHeatmap(rownames(refCor), GSE19188$emat, GSE19188$groupVec)

}
\seealso{
\code{\link[=calcCCD]{calcCCD()}}, \code{\link[=calcDeltaCCD]{calcDeltaCCD()}}, \code{\link[=plotRefHeatmap]{plotRefHeatmap()}}
}
