% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_group}
\alias{add_group}
\alias{add_ungroup}
\title{Add aggregation to pipelines}
\usage{
add_group(object, ...)

add_ungroup(object, ...)
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{Variables on which data is to be grouped.}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_group()} allows for the injection of aggregation into the transformation
pipeline.  Should you need to apply a transformation under aggregation (e.g.
\code{add_shuffle}) this helper creates a grouped \code{data.frame} as would be done
with \code{\link[dplyr:group_by]{dplyr::group_by()}}.
The function \code{add_ungroup()} is supplied to perform the inverse operation.
}
\examples{
pipe.grouped <- add_group(ShiftsWorked, Date, Shift)
pipe.grouped_shuffle <- add_shuffle(pipe.grouped, `Daily Pay`)
add_ungroup(pipe.grouped_shuffle, `Daily Pay`)
}
\keyword{API}
