% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{eel_biogeo_data}
\alias{eel_biogeo_data}
\title{Data summarizing the evolution of geographic ranges in eels}
\format{
A list with 9 elements.
}
\usage{
data(eel_biogeo_data)
}
\description{
A list containing (fake) geographic ranges data of eels mapped on the phylogeny,
modeled with R package \code{BioGeoBEARS}. This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
Initial data based on feeding habits was altered to be transformed into range "A" and "B", and then adding arbitrarily multi-area "AB" ranges.
This is NOT real biogeographic data. Please refer to the initial article for real data.

Original data source: Collar, D. C., P. C. Wainwright, M. E. Alfaro, L. J. Revell, and R. S. Mehta (2014) Biting disrupts integration to spur skull evolution in eels. Nature Communications, 5, 5505.
\doi{10.1038/ncomms6505}
}
\details{
A list of 9 elements containing information on the evolution of geographic ranges in eels.
This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
\itemize{
\item \verb{$densityMaps} List of objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given range along branches. The list contains only a \verb{"densityMap} per unique areas because \code{split_multi_area_ranges} was set to TRUE.
\item \verb{$densityMaps_all_ranges} List of objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given range along branches. The list contains one \verb{"densityMap} per range found along branches during the simulated biogeographic histories.
\item \verb{$trait_data_type} Character string. Record the type of trait data. Here: "biogeographic".
\item \verb{$ace} Numerical matrix that record the posterior probabilities of ancestral ranges estimated at internal nodes.
Only unique areas are considered among the ranges. Multi-area ranges have been split among unique ranges.
Rows are internal nodes. Columns are ranges. Values are posterior probabilities of each range per node.
\item \verb{$ace_all_ranges} Numerical matrix that record the posterior probabilities of ancestral ranges estimated at internal nodes.
All ranges observed along branches during the simulated biogeographic histories are present.
Rows are internal nodes. Columns are ranges. Values are posterior probabilities of each range per node.
\item \verb{$BSM_output} List of two lists that contains summary information of cladogenetic (\verb{$RES_caldo_events_tables}) and anagenetic (\verb{$RES_ana_events_tables}) events
recording across the 1000 simulations of biogeographic histories performed during Biogeographic Stochastic Mapping (BSM).
Each element of the list is a data.frame recording events occurring during one simulation.
\item \verb{$simmaps} List of 1000 objects of class \code{"simmap"}.
Each simmap object is a phylogeny with one simulated biogeographic history (i.e., transitions in geographic ranges) mapped along branches.
\item \verb{$best_model_fit} List that provides the output of the best fitting model (Here: DEC+J model).
\item \verb{$model_selection_df} Data.frame that summarizes model comparisons used to select the best fitting model.
}
}
\references{
Collar, D. C., P. C. Wainwright, M. E. Alfaro, L. J. Revell, and R. S. Mehta (2014) Biting disrupts integration to spur skull evolution in eels. Nature Communications, 5, 5505.
\doi{10.1038/ncomms6505}
}
\seealso{
\code{\link[=prepare_trait_data]{prepare_trait_data()}}
}
\keyword{datasets}
