% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorrelate.R
\name{mult_eclairs}
\alias{mult_eclairs}
\title{Multiply by eclairs matrix}
\usage{
mult_eclairs(X, U1, dSq1, lambda, nu, alpha, sigma, transpose = FALSE)
}
\arguments{
\item{X}{matrix to be transformed so *columns* are independent}

\item{U1}{orthonormal matrix with k columns representing the low rank component}

\item{dSq1}{eigen values so that \eqn{U_1 diag(d_1^2) U_1^T} is the low rank component}

\item{lambda}{shrinkage parameter for the convex combination.}

\item{nu}{diagonal value of target matrix in shrinkage}

\item{alpha}{exponent to be evaluated}

\item{sigma}{standard deviation of each feature}

\item{transpose}{logical, (default FALSE) indicating if X should be transposed first}
}
\value{
a matrix product
}
\description{
Multiply by \link{eclairs} matrix using special structure to achieve linear instead of cubic time complexity.
}
\details{
Let \eqn{\Sigma = U_1 diag(d_1^2) U_1^T * (1-\lambda) + diag(\nu\lambda, p)}, where \eqn{\lambda} shrinkage parameter for the convex combination between a low rank matrix and the diagonal matrix with values \eqn{\nu}.

Evaluate \eqn{X \Sigma^\alpha} using special structure of the \link{eclairs} decomposition in \eqn{O(k^2p)} when there are \eqn{k} components in the decomposition.
}
