# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ code to build models, internal function
#' @description
#' Build a ddsPLS model once the bootstrap operations has allowed to find a correct lambda.
#' @param U The weights for X part.
#' @param V The weights for Y part.
#' @param X The matrix of X part.
#' @param Y The matrix of X part.
#' @param lambdas The to be tested values for lambda.
#' @param R The number of components to build.
#' @param n The number of observations.
#' @param p The number of variables of X part.
#' @param q The number of variables of Y part.
#' @param lambda0 The vector of regulation parameters.
#'
modelddsPLSCpp_Rcpp <- function(U, V, X, Y, lambdas, R, n, p, q, lambda0) {
    .Call('_ddsPLS_modelddsPLSCpp_Rcpp', PACKAGE = 'ddsPLS', U, V, X, Y, lambdas, R, n, p, q, lambda0)
}

#' @title C++ implementation of the bootstrap operations
#' @description
#' Start the bootstrap operations.
#' Should not be used by user.
#' @param U The weights for X part.
#' @param V The weights for Y part.
#' @param X The matrix of X part.
#' @param Y The matrix of X part.
#' @param lambdas The to be tested values for lambda.
#' @param lambda_prev The previously selected values for lambda.
#' @param R The number of components to build.
#' @param n_B The number of bootstrap samples to generate and analyse.
#' @param doBoot Wheteher do bootstrap operations.
#' @param n The number of observations.
#' @param p The number of variables of X part.
#' @param q The number of variables of Y part.
#' @param N_lambdas The number of to be tested values for lambda.
#' @param lambda0 The vector of lambda0
#'
bootstrap_Rcpp <- function(U, V, X, Y, lambdas, lambda_prev, R, n_B, doBoot, n, p, q, N_lambdas, lambda0) {
    .Call('_ddsPLS_bootstrap_Rcpp', PACKAGE = 'ddsPLS', U, V, X, Y, lambdas, lambda_prev, R, n_B, doBoot, n, p, q, N_lambdas, lambda0)
}

