% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.dcsvm.R
\name{predict.cv.dcsvm}
\alias{predict.cv.dcsvm}
\title{Make Predictions from a "cv.dcsvm" Object}
\usage{
\method{predict}{cv.dcsvm}(object, newx, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A fitted \code{\link{cv.dcsvm}} object.}

\item{newx}{A matrix of new values for \code{x} at which predictions are to be made. Must be a matrix. See documentation for \code{predict.dcsvm}.}

\item{s}{Value(s) of the L1 tuning parameter \code{lambda} for making predictions. Default is \code{s = "lambda.1se"} saved in the \code{cv.dcsvm} object. An alternative choice is \code{s = "lambda.min"}. \code{s} can also be numeric, representing the specific value(s) to use.}

\item{...}{Not used. Other arguments to \code{predict}.}
}
\value{
Predicted class labels or fitted values, depending on the choice of \code{s} and any arguments passed to the \code{\link{dcsvm}} method.
}
\description{
Predicts class labels for new data based on the cross-validated \code{lambda} values from a \code{cv.dcsvm} object.
}
\details{
Make Predictions from a "cv.dcsvm" Object

This function predicts the class labels of new observations using the sparse density-convoluted SVM at the \code{lambda} values suggested by \code{\link{cv.dcsvm}}.


This function uses the cross-validation results to make predictions. It is adapted from the \code{predict.cv} function in the \code{glmnet} and \code{gcdnet} packages.
}
\examples{
data(colon)
colon$x <- colon$x[ , 1:100] # Use only the first 100 columns for this example
set.seed(1)
cv <- cv.dcsvm(colon$x, colon$y, lam2=1, nfolds=5)
predict(cv$dcsvm.fit, newx=colon$x[2:5, ], 
  s=cv$lambda.1se, type="class")

}
\seealso{
\code{\link{cv.dcsvm}}, and \code{\link{coef.cv.dcsvm}} methods.
}
