% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.dcsvm.R
\name{coef.cv.dcsvm}
\alias{coef.cv.dcsvm}
\title{Compute Coefficients from a "cv.dcsvm" Object}
\usage{
\method{coef}{cv.dcsvm}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A fitted \code{\link{cv.dcsvm}} object, obtained by conducting cross-validation on the sparse density-convoluted SVM model.}

\item{s}{Value(s) of the L1 tuning parameter \code{lambda} for computing coefficients. Default is \code{"lambda.1se"}, the largest \code{lambda} value achieving a cross-validation error within one standard error of the minimum. Alternatively, \code{"lambda.min"} corresponds to the \code{lambda} incurring the least cross-validation error. \code{s} can also be numeric, specifying the value(s) to use.}

\item{...}{Other arguments that can be passed to \code{\link{dcsvm}}.}
}
\value{
The returned object depends on the choice of \code{s} and any additional arguments passed to the \code{\link{dcsvm}} method.
}
\description{
Computes the coefficients at specified \code{lambda} values for a \code{cv.dcsvm} object.
}
\details{
Compute Coefficients from a "cv.dcsvm" Object

Computes coefficients at chosen values of \code{lambda} from the \code{\link{cv.dcsvm}} object.


This function computes the coefficients for \code{lambda} values suggested by cross-validation.
}
\examples{
data(colon)
colon$x <- colon$x[ ,1:100] # Use only the first 100 columns for this example
set.seed(1)
cv <- cv.dcsvm(colon$x, colon$y, lam2=1, nfolds=5)
c1 <- coef(cv, s="lambda.1se")

}
\seealso{
\code{\link{cv.dcsvm}} and \code{\link{predict.cv.dcsvm}} methods.
}
