% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_check.R
\name{id_check}
\alias{id_check}
\title{ID Check}
\usage{
id_check(DS.data, verbose = TRUE)
}
\arguments{
\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as more detailed diagnostic information.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (Time stamp); (2) Name (Name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (Detailed information about the four ID checks that were performed).
}
\description{
This function checks that the first column of the data set is the primary ID for each participant labeled as \code{SUBJECT_ID}, that values contain no illegal characters or padded zeros, and that each participant has an ID.
}
\details{
Subject IDs should be an integer or string value. Integers should not have zero padding. IDs should not have spaces. Specifically, only the following characters can be included in the ID: English letters, Arabic numerals, period (.), hyphen (-), underscore (_), at symbol (@), and the pound sign (#). All IDs should be filled in (i.e., no misisng IDs are allowed).
}
\examples{
# Example 1: Fail check, 'SUBJECT_ID' not present
data(ExampleO)
id_check(DS.data.O)
print(id_check(DS.data.O, verbose=FALSE))

# Example 2: Fail check, 'SUBJECT_ID' includes illegal spaces
data(ExampleP)
id_check(DS.data.P)
results <- id_check(DS.data.P)
results$Information[[1]]$details
print(id_check(DS.data.P, verbose=FALSE))

# Example 3: Pass check
data(ExampleA)
id_check(DS.data.A)
print(id_check(DS.data.A, verbose=FALSE))
}
\seealso{
\code{\link{id_first_data}}

\code{\link{id_first_dict}}
}
