% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{SubmitActuals}
\alias{SubmitActuals}
\title{Submit actuals for processing.}
\usage{
SubmitActuals(actuals, deploymentId, batchSize = 10000)
}
\arguments{
\item{actuals}{dataframe. Data that describes actual values. Any strings stored as factors will
be coerced to characters with \code{as.character}. Allowed columns are:
\itemize{
   \item associationId string. A unique identifier used with a prediction. Max length 128
     characters.
   \item actualValue string or numeric. The actual value of a prediction;
     should be numeric for deployments with regression models or string for deployments with
     classification model.
   \item wasActedOn logical. Optional. Indicates if the prediction was acted on in a way that
     could have affected the actual outcome.
   \item timestamp POSIXt. Optional. If the datetime provided does not have a timezone, we assume
     it is UTC.
}}

\item{deploymentId}{character. The ID of the deployment.}

\item{batchSize}{integer. Optional. The max number of actuals in each batch request. Cannot
exceed 10000.}
}
\description{
The actuals submitted will be used to calculate accuracy metrics.
Values are not processed immediately and may take some time to propagate through deployment
systems. Submission of actuals is limited to 10,000,000 actuals per hour. For time series
deployments, total actuals = number of actuals * number of forecast distances. For example,
submitting 10 actuals for a deployment with 50 forecast distances = 500 total actuals. For
multiclass deployments, a similar calculation is made where total actuals = number of actuals *
number of classes. For example, submitting 10 actuals for a deployment with 20 classes = 200
actuals.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  myActuals <- data.frame(associationId = c("439917"),
                          actualValue = c("True"),
                          wasActedOn = c(TRUE))
  SubmitActuals(actuals = myActuals,
                deploymentId)
}
}
\seealso{
Other deployment accuracy functions: 
\code{\link{GetDeploymentAccuracyOverTime}()},
\code{\link{GetDeploymentAccuracy}()},
\code{\link{GetDeploymentAssociationId}()}
}
\concept{deployment accuracy functions}
