% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabtexanova.r, R/tabtexregre.r
\name{tabtexanova}
\alias{tabtexanova}
\alias{tabtexregre}
\title{Creates a LaTeX file having an ANOVA table
for a previously fitted linear regression model}
\usage{
tabtexanova(
  mod = mod,
  nametab = nametab,
  cap = cap,
  save.file = FALSE,
  filename = "tabregre.tex",
  eng = TRUE,
  rowlab = "Source of variation",
  decnum = 3,
  font.size.tab = "normalsize",
  font.type.tab = "normalfont",
  ...
)

tabtexregre(
  mod = mod,
  nametab = nametab,
  cap = cap,
  save.file = FALSE,
  filename = "tabregre.tex",
  eng = TRUE,
  rowlab = "Parameter",
  decnum = 3,
  font.size.tab = "normalsize",
  font.type.tab = "normalfont",
  ...
)
}
\arguments{
\item{mod}{an object containing the fitted model by using
the \code{lm()} function.}

\item{nametab}{a string having a brief name to be used in
both the label of the table and the file name. For instance,
if "=mod1", the table can be refered in your LaTeX
document by using \verb{\\ref\{tab:mod1\}}}

\item{cap}{a string having the caption of the LaTeX table.}

\item{save.file}{The defauls is set to ``FALSE'', if is set to
TRUE, then the option \code{filename} must be provided.}

\item{filename}{A string having the name of the resulting LaTeX
file having the table. The default is set to "tabdescdata.tex".}

\item{eng}{The language to be used in the output. English
is the default, meanwhile if \code{eng}=FALSE, Spanish is used.}

\item{rowlab}{a character with the name to be used as label for
the column where the variables will be printed. The default is
set to "Parameter".}

\item{decnum}{the number of decimals to be used in the output. The
default is set to 3.}

\item{font.size.tab}{The defauls is set to "normalsize". You could
also try with "footnotesize".}

\item{font.type.tab}{The defauls is set to "normalfont".}

\item{...}{Other options of the main functions being used here.}
}
\value{
This function creates a LaTeX file having
an ANOVA table, from a fitted regression model.

This function creates a LaTeX file having
the main fitting statistics of a linear regression model.
}
\description{
Function to create a LaTeX file of an ANOVA table.

Function to create a LaTeX file for a table with
the main fitting statistics from a fitted regression model.
}
\details{
The resulting file is a LaTeX table, that can be
added to your main LaTeX document by using \verb{\\input\{filename\}}.

The resulting file is a LaTeX table, that can be
added to your main LaTeX document by using \verb{\\input\{filename\}}.
}
\examples{

df <- datana::fishgrowth2
head(df)
descstat(df[,c("largo","edad")])
plot(largo ~ edad, data=df)
mod1<-lm(largo ~ edad, data=df)
##example 1
tabtexanova(mod=mod1,nametab="anovatab",
cap="ANOVA-style table of the fitted regression model")
##example 2
tabtexanova(mod=mod1,nametab="anovatab",
cap="Cuadro estilo ANOVA para modelo de regresion ajustado",
eng=FALSE)

df <- datana::fishgrowth2
head(df)
datana::descstat(df[,c("largo","edad")])
graphics::plot(largo ~ edad, data=df)
mod1<-stats::lm(largo ~ edad, data=df)
## Example 1
tabtexregre(mod=mod1,nametab="basicmodel",
cap="Parameter estimates of the fitted regression model")
## Example 2
tabtexregre(mod=mod1,nametab="basicmodel",
cap="Cuadro con parametros estimados del modelo de regresion",
eng=FALSE)
}
\references{
Salas-Eljatib, C. 2021. Análisis de datos con el programa
estadístico R: una introducción aplicada. Ediciones Universidad
Mayor, Santiago, Chile. 170 p. \url{https://eljatib.com/rlibro}

Salas-Eljatib, C. 2021. Análisis de datos con el programa
estadístico R: una introducción aplicada. Ediciones Universidad
Mayor, Santiago, Chile. 170 p. \url{https://eljatib.com/rlibro}
}
\author{
Christian Salas-Eljatib.
}
