% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.drop.ind.r
\name{gl.drop.ind}
\alias{gl.drop.ind}
\title{Removes specified individuals from a dartR genlight object}
\usage{
gl.drop.ind(x, ind.list, recalc = FALSE, mono.rm = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{ind.list}{List of individuals to be removed [required].}

\item{recalc}{If TRUE, recalculate the locus metadata statistics [default FALSE].}

\item{mono.rm}{If TRUE, remove monomorphic and all NA loci [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress but not results; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A reduced dartR genlight object
}
\description{
This function deletes individuals and their associated metadata.
Monomorphic loci and loci that are scored all NA are optionally deleted (mono.rm=TRUE). 
The script also optionally recalculates locus metatdata statistics to accommodate
the deletion of individuals from the dataset (recalc=TRUE).

The script returns a dartR genlight object with the retained individuals 
and the recalculated locus metadata. The script works with both genlight objects
containing SNP genotypes and Tag P/A data (SilicoDArT).
}
\examples{
 # SNP data
   gl2 <- gl.drop.ind(testset.gl,
   ind.list=c('AA019073','AA004859'))
 # Tag P/A data
   gs2 <- gl.drop.ind(testset.gs,
   ind.list=c('AA020656','AA19077','AA004859'))
   gs2 <- gl.drop.ind(testset.gs, ind.list=c('AA020656'
   ,'AA19077','AA004859'),mono.rm=TRUE, recalc=TRUE)
}
\seealso{
\code{\link{gl.keep.ind}} to keep rather than drop specified
individuals

Other dartR-base: 
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.ind}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.read.dart}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.set.verbosity}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{dartR-base}
