% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_tune.R
\name{clu_tune}
\alias{clu_tune}
\title{Clustering tuning (intrinsic metric)}
\usage{
clu_tune(base_model, folds = 10, ranges = NULL)
}
\arguments{
\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}

\item{ranges}{a list of hyperparameter ranges to explore}
}
\value{
returns a \code{clu_tune} object.
}
\description{
Tune clustering hyperparameters by evaluating an intrinsic metric over a parameter grid and selecting the elbow (max curvature).
}
\examples{
data(iris)

# fit model
model <- clu_tune(cluster_kmeans(k = 0), ranges = list(k = 1:10))

model <- fit(model, iris[,1:4])
model$k
}
\references{
Satopaa, V. et al. (2011). Finding a “Kneedle” in a Haystack.
}
