% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{combine}
\alias{combine}
\title{Combine several data.frames by rowbind}
\usage{
combine(...)
}
\arguments{
\item{...}{data.frames or matrices with not necessarily overlapping colnames}
}
\value{
A \code{data.frame}
}
\description{
Combine several data.frames by rowbind
}
\details{
This function is useful when separating models into independent csv model files,
e.g.~a receptor model and several downstream pathways. Then, the models can be recombined 
into one model by \code{combine()}.
}
\examples{
data1 <- data.frame(Description = "reaction 1", Rate = "k1*A", A = -1, B = 1)
data2 <- data.frame(Description = "reaction 2", Rate = "k2*B", B = -1, C = 1)
combine(data1, data2)
}
