% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{effect}
\alias{effect}
\alias{effect,EffectScenario-method}
\alias{effect,ScenarioSequence-method}
\title{Effect level}
\usage{
effect(x, ...)

\S4method{effect}{EffectScenario}(x, factor = 1, max_only = TRUE, ep_only = FALSE, marginal_effect, ...)

\S4method{effect}{ScenarioSequence}(x, ...)
}
\arguments{
\item{x}{a \link{scenario} objects}

\item{...}{additional parameters passed on to \code{\link[=simulate]{simulate()}}}

\item{factor}{optional numeric value which scales the exposure time-series}

\item{max_only}{\code{logical}, if \code{TRUE} only the maximum effect is returned, else
results for all effect windows are reported}

\item{ep_only}{logical, if TRUE only effect endpoints are returned as a vector}

\item{marginal_effect}{\code{numeric}, if set, any effect smaller than this threshold will
be reported as zero to exclude pseudo-effects originating from small numerical
errors}
}
\value{
a \code{tibble}, by default containing scenarios, effect levels, and the
exposure window where the maximum effect level occurred. The number of columns
depends on the enabled effect endpoints and function arguments.

By default, the first column, named \code{scenarios}, contains the original scenario
objects that were the basis of the calculation. For each effect endpoint, it
will be followed by one column with the maximum effect level and two columns
containing start and end time of the associated exposure window. If exposure
windows are disabled, the columns will just contain the start and end time of
the simulation. The effect level column will have the name of the effect
endpoint, start and end time will additionally have the suffixes \code{.dat.start}
and \code{.dat.end}, respectively.
}
\description{
Derives the effect level due to toxicant exposure in the supplied scenarios.
Either relative to a control scenario or derived directly from model
endpoints, depending on model type. For scenarios with moving exposure windows,
the maximum effect is returned.
}
\details{
By default, only the maximum effect in all moving exposure windows will
be returned. If argument \code{max_only=FALSE} is set, the returned table will
be converted to long-format and will contain effect levels for each
assessed exposure window.
\subsection{Calculation}{

Effects are calculated similarly to \emph{relative errors}, i.e. the difference
between control and treatment scenarios is divided by the absolute value
of the control. Effects are usually in the interval \verb{[0,1]}, but values
larger than one or smaller than zero can occur. As a special case, if the
endpoint from the control scenario is zero, then the effect is either
\itemize{
\item zero, if also the treatment is zero
\item positive infinity, if the treatment is smaller than zero
\item negative infinity, if the treatment is greater than zero
}

As an example, a control scenario achieves a biomass of
1.0 and the treatment scenario achieves a biomass of 0.9, the effect will
be equal to 0.1 or 10\%. However, effects can take on any real value. If,
for example, the biomass of the previously mentioned treatment scenario drops
below zero, then an effect larger than 1.0 will be calculated If, instead,
the biomass in the treatment scenario is greater than in the control, then the
effect will be negative.
\subsection{Output formatting}{

Start and end time of exposure windows can be disabled by setting \code{ep_only=TRUE}.
Effect levels smaller than a certain threshold can be automatically set to
zero (\code{0.0}) to avoid spurious effect levels introduced by numerical errors.
Set \code{marginal_effect} to an adequate value less than 1\%.
}

\subsection{Computational efficiency}{

Calculations can be sped up by providing a \code{data.frame} of pre-calculated
control scenarios for each assessed time window. As control scenarios are
by definition independent of any exposure multiplication factor, they can
be reused for repeated calculations, e.g. to derive effect profiles or
dose-response relationships.
}

}
}
\section{Methods (by class)}{
\itemize{
\item \code{effect(EffectScenario)}: Default for all generic \link{scenarios}

\item \code{effect(ScenarioSequence)}: For scenario \link[=sequence]{sequences}

}}
