% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumLexc_alphaweibull_topred.R
\name{cumLexc_alphaweibull_topred}
\alias{cumLexc_alphaweibull_topred}
\title{cumLexc_alphaweibull_topred function}
\usage{
cumLexc_alphaweibull_topred(
  z_ucured = z_ucured,
  z_pcured = z_pcured,
  x = x,
  theta = theta,
  sign_delta = 1
)
}
\arguments{
\item{z_ucured}{covariates matrix acting on survival function of uncured}

\item{z_pcured}{covariates matrix acting on cure proportion.}

\item{x}{the time arguments at which to calculate the cumulative excess hazard}

\item{theta}{the parameters of the cumulative excess hazard from a Weibull distribution}

\item{sign_delta}{only used for mixture cure rate models to specify if the
effects or minus the effects of covariates acting on uncured survival to be
considered. Default will be sign_delta = "1". The alternative is
sign_delta = "-1".}
}
\value{
This object is a list containing the following components:

\item{cumhaz}{cumulative excess hazard estimates}
\item{usurv}{survival of uncured}
\item{SurvE}{net survival estimates}
\item{cured}{cure fraction}
\item{pt_cure}{the conditionnal probability of being cured knowing they are alive at t}
}
\description{
calculates the cumulative excess hazard from a Weibull distribution
}
\author{
Juste Goungounga, Judith Breaud, Olayide Boussari, Laura Botta, Valerie Jooste
}
\keyword{cumLexc_alphaweibull_topred}
\keyword{internal}
