% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_form_definition.R
\name{cto_form_metadata}
\alias{cto_form_metadata}
\alias{cto_form_definition}
\title{Download SurveyCTO Form Metadata and Definitions}
\usage{
cto_form_metadata(form_id)

cto_form_definition(form_id, version = NULL, dir = getwd(), overwrite = FALSE)
}
\arguments{
\item{form_id}{A string giving the unique SurveyCTO form ID.}

\item{version}{Optional string specifying a particular form version to download.
If \code{NULL} (default), the currently deployed version is used.}

\item{dir}{Directory where the XLSForm should be saved. Defaults to \code{getwd()}.}

\item{overwrite}{Logical; if \code{TRUE}, an existing file in \code{dir} will be
overwritten. If \code{FALSE} (default), the existing file is used.}
}
\value{
\itemize{
\item \code{cto_form_metadata()} returns a list containing the metadata, including
keys for \code{deployedGroupFiles} and \code{previousDefinitionFiles}.
\item \code{cto_form_definition()} returns a character string with the path to the downloaded Excel file.
}
}
\description{
Functions for interacting with SurveyCTO form definitions.
\itemize{
\item \code{cto_form_metadata()} retrieves raw metadata for a form, including
available definition files, version identifiers, and download URLs.
\item \code{cto_form_definition()} downloads a specific XLSForm definition (Excel file)
to a local directory.
}
}
\details{
\itemize{
\item \strong{Version Handling:} When \code{version} is supplied, it is validated against
the available versions from \code{cto_form_metadata()}. An informative error is raised
if the requested version does not exist.
\item \strong{Caching:} If the file already exists in \code{dir}, it will not be re-downloaded
unless \code{overwrite = TRUE}.
}
}
\examples{
\dontrun{
# --- 1. Get raw metadata ---
meta <- cto_form_metadata("household_survey")

# --- 2. Download the current form definition ---
file_path <- cto_form_definition("household_survey")

# --- 3. Download a specific historical version ---
file_path_v <- cto_form_definition(
  "household_survey",
  version = "20231001"
)

# --- 4. Read XLSForm manually with readxl ---
library(readxl)
survey <- read_excel(file_path, sheet = "survey")
choices <- read_excel(file_path, sheet = "choices")
settings <- read_excel(file_path, sheet = "settings")
}
}
\seealso{
Other Form Management Functions: 
\code{\link{cto_form_attachment}()},
\code{\link{cto_form_data}()},
\code{\link{cto_form_data_attachment}()},
\code{\link{cto_form_dofile}()},
\code{\link{cto_form_languages}()}
}
\concept{Form Management Functions}
