% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_avg.R
\name{cross_sectional_avg}
\alias{cross_sectional_avg}
\title{Cross-sectional averages by time (with optional leave-one-out)}
\usage{
cross_sectional_avg(
  data,
  id = NULL,
  time = NULL,
  vars,
  leave_out = FALSE,
  weights = NULL,
  suffix = "csa",
  return_mode = c("attach", "time"),
  na.rm = TRUE
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{plm::pdata.frame}.}

\item{id, time}{Character scalar names of unit and time columns when \code{data}
is a plain \code{data.frame}. If \code{data} is a \code{pdata.frame}, these are
inferred from its index and can be omitted.}

\item{vars}{Character vector of column names to average cross-sectionally.}

\item{leave_out}{Logical; if \code{TRUE}, computes LOO means for each row:
\eqn{\bar{x}_{-i,t} = (\sum_{j \neq i} w_{jt} x_{jt}) / (\sum_{j \neq i} w_{jt})}.
If \code{FALSE}, computes standard time means:
\eqn{\bar{x}_{t} = (\sum_j w_{jt} x_{jt}) / (\sum_j w_{jt})}.}

\item{weights}{Optional. Either:
\itemize{
\item a numeric vector of length \code{nrow(data)}, or
\item the name of a column in \code{data} with nonnegative weights.
}
If \code{NULL}, uses equal weights (1 for observed values).}

\item{suffix}{Character suffix to append to CSA columns (default \code{"csa"}).}

\item{return_mode}{One of \code{"attach"} or \code{"time"}.
\itemize{
\item \code{"attach"} returns the original \code{data} with CSA columns added.
\item \code{"time"} returns a unique-time table \code{[time, csa_*]}.
}}

\item{na.rm}{Logical; if \code{TRUE}, excludes \code{NA}s from sums and
denominators. If \code{FALSE}, any \code{NA} in a time slice yields \code{NA}
for that time's CSA for that variable.}
}
\value{
A \code{data.frame}:
\itemize{
\item If \code{return_mode="attach"}: original data + CSA columns
named \code{paste0(suffix, "_", vars)}.
\item If \code{return_mode="time"}: unique time rows with CSA columns.
}
}
\description{
Computes cross-sectional averages (CSAs) of specified variables for each time
period, optionally in a leave-one-out (LOO) fashion per observation. Supports
unbalanced panels and observation weights.
}
\details{
Efficiently computes, for each \code{v in vars} and time \code{t},
\deqn{\bar v_t = \frac{\sum_i w_{it}\, 1_{\{v_{it}\text{ finite}\}}\, v_{it}}
                {\sum_i w_{it}\, 1_{\{v_{it}\text{ finite}\}}}}
For \code{leave_out=TRUE}, each row's CSA excludes its own contribution; if the
denominator becomes \eqn{\le 0} (e.g., only one finite observation at that time),
the LOO mean is set to \code{NA} for that row/variable.
}
\keyword{internal}
