% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRuleLibrary.R
\name{getRulesAsStrings}
\alias{getRulesAsStrings}
\title{Represent binary rule matrix as strings}
\usage{
getRulesAsStrings(rm)
}
\arguments{
\item{rm}{binary rule matrix}
}
\value{
vector or rules represented as strings
}
\description{
Represent binary rule matrix as strings
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
rm.full <- buildRuleLibrary(D,rule.thresh = 0.1) # Small rule library matrix, dimension: 5 x 71
getRulesAsStrings(rm.full)
# output should be: "BRAF-M.CDKN2A-MD"   "CDKN2A-MD.NRAS-M"
# "BRAF-M.PTEN-MD"    "ADAM18-M.BRAF-M" "ADAM18-M.CDKN2A-MD"
}
