% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractResults.R
\name{getBestRsList}
\alias{getBestRsList}
\title{Get list of best rule sets of size K for all K}
\usage{
getBestRsList(rm, tpl, til)
}
\arguments{
\item{rm}{binary rule matrix}

\item{tpl}{list of top performances}

\item{til}{list of top rule set index matrices}
}
\description{
Get list of best rule sets of size K for all K
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,pool.sizes=c(60,20,20),
          max.stored=100,shouldPrint = FALSE)
tpl.p2 <- evaluateListOfIMs(D,Q,rm.full,til.p2)
best.rs.list <- getBestRsList(rm = rm.full,tpl = tpl.p2,til = til.p2)
}
