% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRuleLibrary.R
\name{buildRuleLibrary}
\alias{buildRuleLibrary}
\title{Make full rule library of all rules that satisfy minimum coverage threshold.}
\usage{
buildRuleLibrary(D, rule.thresh, min.epr)
}
\arguments{
\item{D}{Binary matrix of N events and M samples}

\item{rule.thresh}{Minimum fraction of rules covered. Default is .03}

\item{min.epr}{minimum events per rule. Default is 2.}
}
\description{
Make full rule library of all rules that satisfy minimum coverage threshold.
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # build rule library
dim(rm.full) # Should be matrix with dimension 60 x 71
}
