% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{idx_mod}
\alias{idx_mod}
\alias{pass_named}
\alias{is.int}
\alias{required_no_default}
\title{Internal helper utilities}
\usage{
idx_mod(n, mod)

pass_named(fun, args)

is.int(n)

required_no_default(fun)
}
\arguments{
\item{n}{Integer index or count used in modulo arithmetic.}

\item{mod}{Modulus (number of folds).}

\item{fun}{A function to be called.}

\item{args}{A named list of arguments.}
}
\value{
Various small values used for internal control flow and
argument handling.
}
\description{
Small utilities used internally by the cross-fitting engine.
}
\details{
\itemize{
\item \code{idx_mod()} wraps panel indices modulo the number of folds,
using 1-based indexing.
\item \code{pass_named()} calls a function with only the arguments
it declares, dropping unknown ones defensively.
\item \code{is.int()} checks whether a value is a non-negative
scalar integer (within floating-point tolerance).
\item \code{required_no_default()} returns the names of required
formals (arguments without defaults) of a function.
}

These helpers are not intended for direct use by end users.
}
\keyword{internal}
