% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerDataOppnHA.R
\name{getPlayerDataOppnHA}
\alias{getPlayerDataOppnHA}
\title{Return a filtered CSV file for a player against specified opposition, at home/away venues during an interval}
\usage{
getPlayerDataOppnHA(infile,outfile,dir=".",opposition=c("all"),homeOrAway=c("all"),
                          startDate="2001-01-01",endDate="2019-01-01")
}
\arguments{
\item{infile}{The input CSV HA file for the player}

\item{outfile}{The name of the output CSV file which is filtered file based on opposition,home/away for a period}

\item{dir}{The name of the directory to store output file}

\item{opposition}{This is a vector of opposition for e.g. c("Australia","India","South Africa"). Default is c("all")}

\item{homeOrAway}{This is a vector of "home","away" or "neutral". Default is c("all")}

\item{startDate}{This is a date from which you would like the data for player "yyyy-mm-dd" format}

\item{endDate}{This is a end date till which you need data to be filtered of "yyyy-mm-dd" format}
}
\value{
dataframe
}
\description{
This function saves the filtered players data as a CSV file for matches against specified opposition,
at home.away venues for a specified interval
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get data for Kohli  against England in 'away' venues in the year 2014
df=getPlayerDataOppnHA(infile="kohliHA.csv",outfile="kohliEAN2014.csv",
            opposition=c("England","Australia","New Zealand"),
homeOrAway=c("away"),startDate="2014-01-01",endDate="2015-01-01")

# Get data for Tendulkar between 2001 and 2002
df1=getPlayerDataOppnHA(file,outfile="tendulkar2001.csv",startDate="2001-01-01",
                                                         endDate="2002-01-01")

}
}
\references{
\url{https://www.espncricinfo.com/ci/content/stats/index.html}\cr
\url{https://gigadom.in/}\cr
}
\seealso{
\code{\link{teamWinLossStatusVsOpposition}}
\code{\link{batsman4s6s}}
}
\author{
Tinniam V Ganesh
}
