% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps_read.R
\name{cps_read_year}
\alias{cps_read_year}
\title{Load a single CPS file}
\usage{
cps_read_year(
  file,
  cols = cpsvote::cps_cols,
  names_col = "new_name",
  year = as.numeric(stringr::str_extract(file, "\\\\d{4}"))
)
}
\arguments{
\item{file}{Where the fixed-width or zip/gz file for this year's data lives}

\item{cols}{Which columns to read. This must be a data frame, with required
columns \code{start_pos} and \code{end_pos}. The default value is \code{cps_cols}, which
reads from the list \code{cpsvote::cps_cols}. See \code{vignette("add-variables")} for
details about how to specify a different set of \code{cols}.}

\item{names_col}{The column in \code{cols} that contains column names for the
specified columns. If none exists, use \code{names_col = NULL}}

\item{year}{Which year is being read; defaults to 4-digit year in file name}
}
\value{
a data frame, with dimensions depending on the year and columns specified
}
\description{
Read one year of data from the Current Population Survey
}
