% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{probability_any}
\alias{probability_any}
\title{Find the probability of any (at least one) event happening}
\usage{
probability_any(n, p)
}
\arguments{
\item{n}{The number of times to repeat the event (independent)}

\item{p}{The individual probability of the event happening}
}
\value{
The probability of an event with the specified probability, after n
repetitions
}
\description{
For an event that occurs with probability p, this function returns
the probability of an occurrence given n repetitions. p is numeric
and can be a vector.
}
\details{
The probability that any event p occurs with n repetitions is equal to the
reciprocal of the probability that p never occurs. The probability that p
never occurs with n repetitions is \code{(1 - p) ^ n}. Thus, the probability
that any event p occurs after n repetitions is \code{1 - ( (1 - p) ^ n )}.
}
\examples{
probability_any(1, 0.5)
probability_any(2, 0.5)
probability_any(2, c(0.5, 1/3, 0.25))
}
